/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.engine.EngineImpl;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.impl.BackendManagerImpl;
import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.FlwImplXplat;
import dev.engine_room.flywheel.impl.visualization.VisualizationManagerImpl;
import dev.engine_room.flywheel.lib.memory.FlwMemoryTracker;
import dev.engine_room.flywheel.lib.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public final class FlwDebugInfo {
    private FlwDebugInfo() {
    }

    public static StringBuilder appendLine(StringBuilder dst, String str) {
        dst.append("\n- ");
        dst.append(str);
        return dst;
    }

    public static void appendHeader(StringBuilder dst, String str) {
        dst.append("\n\n## ");
        dst.append(str);
    }

    public static class_2561 getDebugCommandInfo() {
        StringBuilder out = new StringBuilder("# `/flywheel debug info`");
        VisualizationManagerImpl manager = VisualizationManagerImpl.get((class_1936)class_310.method_1551().field_1687);
        FlwDebugInfo.addImplDebugInfo(out);
        FlwDebugInfo.addSystemDebugInfo(out);
        FlwDebugInfo.addOpenGLDebugInfo(out);
        FlwDebugInfo.addBackendDebugInfo(manager, out);
        FlwDebugInfo.addVisualizationManagerDebugInfo(manager, out);
        String debugInfoString = out.toString();
        return class_2561.method_43470((String)debugInfoString).method_10852((class_2561)class_2561.method_43470((String)"\n\nClick to copy debug info to clipboard").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_21462, debugInfoString)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)debugInfoString))))).method_10852((class_2561)class_2561.method_43470((String)"\n\nClick to open an issue on GitHub").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Engine-Room/Flywheel/issues")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Opens URL:\nhttps://github.com/Engine-Room/Flywheel/issues")))));
    }

    private static void addBackendDebugInfo(@Nullable VisualizationManagerImpl manager, StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "Backend");
        if (manager == null) {
            FlwDebugInfo.appendLine(out, "No visualization manager found");
            return;
        }
        EngineImpl engineImpl = manager.getEngineImpl();
        if (engineImpl == null) {
            FlwDebugInfo.appendLine(out, "Third party backend in use");
            return;
        }
        FlwDebugInfo.appendLine(out, "Environments: ").append(engineImpl.environmentStorage().arena.occupancy()).append(" / ").append(engineImpl.environmentStorage().arena.capacity());
        FlwDebugInfo.appendLine(out, "Light Sections: ").append(engineImpl.lightStorage().arena.occupancy()).append(" / ").append(engineImpl.lightStorage().arena.capacity());
        IntArrayList lut = engineImpl.lightStorage().createLut();
        FlwDebugInfo.appendLine(out, "Light LUT Size: ").append(lut.size() * 4);
    }

    private static void addVisualizationManagerDebugInfo(@Nullable VisualizationManagerImpl manager, StringBuilder out) {
        if (manager == null) {
            out.append('\n');
            FlwDebugInfo.appendHeader(out, "Visualization Manager");
            FlwDebugInfo.appendLine(out, "No visualization manager found");
            return;
        }
        FlwDebugInfo.appendHeader(out, "Client Level Visualization Manager");
        class_2382 renderOrigin = manager.renderOrigin();
        FlwDebugInfo.appendLine(out, "Origin: ").append(renderOrigin.method_10263()).append(", ").append(renderOrigin.method_10264()).append(", ").append(renderOrigin.method_10260());
        FlwDebugInfo.appendLine(out, "Block Entity Visuals: ").append(manager.blockEntities().visualCount());
        FlwDebugInfo.appendLine(out, "Entity Visuals: ").append(manager.entities().visualCount());
        FlwDebugInfo.appendLine(out, "Effect Visuals: ").append(manager.effects().visualCount());
    }

    private static void addImplDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "Impl");
        FlwDebugInfo.appendLine(out, "Flywheel Version: ").append(FlwImplXplat.INSTANCE.getVersionStr());
        FlwDebugInfo.appendLine(out, "Backend: ").append(BackendManagerImpl.getBackendString());
        FlwDebugInfo.appendLine(out, "Update limiting: ").append(FlwConfig.INSTANCE.limitUpdates() ? "on" : "off");
    }

    private static void addSystemDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "System Info");
        FlwDebugInfo.appendLine(out, "Java Version: ").append(System.getProperty("java.version"));
        FlwDebugInfo.appendLine(out, "Java VM: ").append(System.getProperty("java.vm.name")).append(" (").append(System.getProperty("java.vm.version")).append(")");
        FlwDebugInfo.appendLine(out, "OS: ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.arch")).append(")");
        FlwDebugInfo.appendLine(out, "Flw CPU Memory: ").append(FlwMemoryTracker.getCpuMemory());
        FlwDebugInfo.appendLine(out, "Flw GPU Memory: ").append(FlwMemoryTracker.getGpuMemory());
    }

    private static void addOpenGLDebugInfo(StringBuilder out) {
        FlwDebugInfo.appendHeader(out, "OpenGL");
        FlwDebugInfo.appendLine(out, "Vendor: ").append(GlCompat.GL_VENDOR_STRING);
        FlwDebugInfo.appendLine(out, "Renderer: ").append(GlCompat.GL_RENDERER_STRING);
        FlwDebugInfo.appendLine(out, "Version: ").append(GlCompat.GL_VERSION_STRING);
        FlwDebugInfo.appendLine(out, "Shading Language Version: ").append(GlCompat.GL_SHADING_LANGUAGE_VERSION_STRING);
    }

    public static void addDebugInfo(class_310 minecraft, List<String> systemInfo) {
        if (minecraft.method_1555()) {
            return;
        }
        systemInfo.add("");
        systemInfo.add("Flywheel: " + FlwImplXplat.INSTANCE.getVersionStr());
        systemInfo.add("Backend: " + BackendManagerImpl.getBackendString());
        systemInfo.add("Update limiting: " + (FlwConfig.INSTANCE.limitUpdates() ? "on" : "off"));
        VisualizationManager manager = VisualizationManager.get((class_1936)minecraft.field_1687);
        if (manager != null) {
            systemInfo.add("B: " + manager.blockEntities().visualCount() + ", E: " + manager.entities().visualCount() + ", F: " + manager.effects().visualCount());
            class_2382 renderOrigin = manager.renderOrigin();
            systemInfo.add("Origin: " + renderOrigin.method_10263() + ", " + renderOrigin.method_10264() + ", " + renderOrigin.method_10260());
        }
        systemInfo.add("Memory Usage: CPU: " + StringUtil.formatBytes(FlwMemoryTracker.getCpuMemory()) + ", GPU: " + StringUtil.formatBytes(FlwMemoryTracker.getGpuMemory()));
    }
}

